# This script is intended to simplify the process of configuring the _Sites.Selected_ permission to grant your Entra ID application access to your SharePoint site. 
# This script creates and uses a separate Entra app with the _AllSites.FullControl_ permission. The app provides the app setup for Vault permissions to manage documents on your SharePoint site. 


# REQUIRED PRE-REQUISITES :
# 1. Powershell 7.0
# 2. Install SharePoint Online Management Shell and PnP module
# Install-Module -Name Microsoft.Online.SharePoint.PowerShell
# Install-Module PnP.PowerShell -RequiredVersion 2.12

# ##########################################################################################
# UPDATE BELOW VARIABLES
# ##########################################################################################

# Get adminDomainUrl by going to Sharepoint Admin Center and getting the domain of your URL, without HTTPS like in example below
$adminDomainUrl = "client-admin.sharepoint.com"

# Get siteDomainUrl by going to any Active Site > Click on site > get Domain of any existing site in Sharepoint and getting domain of that site (), without HTTPS like in example below
$siteDomainUrl = "client.sharepoint.com"

# Get from Entra Admin Center > Home > Primary domain 
$primaryDomain = "domain.com"

# Get by going to Entra app registration find the registration you just created - Veeva Vault Collaborative Authoring > Overview > Application (client) ID
$appId = "xxx-xxx-xxx-xxx"

# Get by going to Entra app registration finding the registration you just created - Veeva Vault Collaborative Authoring > Overview > Display name
$displayName = "Veeva Vault Collaborative Authoring"

# Get sharepoint site URL you just created by going to Shareoint Admin Center > Site > Active Sites > Find your Vault Site > Site Address -- copy the full site Address 
$siteUrl = "https://test.sharepoint.com/sites/siteAlias"

# ##########################################################################################
# DO NOT UPDATE BELOW THIS LINE
# ##########################################################################################
$adminUrl = "https://" + $adminDomainUrl
$tenantUrl = $primaryDomain
$adminAppName = $displayName + " Application"

Write-Host "Using AppName: $adminAppName" -ForegroundColor Green 
Write-Host "Using Tenant Url: $tenantUrl" -ForegroundColor Green 

# Function to create a SharePoint site with various configuration options
    # Connect to Sharepoint admin
    try {
        if ($entraIDApp -ne $null) {
            $clientId = $entraIDApp
            Write-Host "Using existing Entra ID App: $clientId" -ForegroundColor Green                
        } else {
            $result = Register-PnPEntraIDAppForInteractiveLogin -ApplicationName $adminAppName -SharePointDelegatePermissions "AllSites.FullControl" -Tenant $tenantUrl -Interactive 
            $regexMatch = $result | Select-String -Pattern '@{AzureAppId/ClientId=' -AllMatches
            if ($regexMatch) {
                $clientId = $regexMatch -replace ".*=" -replace "}"
                Write-Host "Created Entra ID App with client id: $clientId" -ForegroundColor Green                
            } else {
                Write-Error "Failed to get id"
                return
            }
        }
    } catch {
        Write-Error "Failed to connect to SharePoint site: $_"
            return
    }

    Write-Host "Connecting to Sharepoint admin" -ForegroundColor Green
    $SPAdminConnection = Connect-PnPOnline $adminUrl -ClientId $clientId -Interactive -ReturnConnection 


    try {
        Grant-PnPAzureADAppSitePermission -AppId $appId -DisplayName $displayName -Site $siteUrl -Permissions Write -Connection $SPAdminConnection
        Write-Host "Granted permission to site" -ForegroundColor Green
    } catch {
        Write-Error "Failed to grant permission to site: $_"
            return
    }
